#!/usr/bin/ruby
# @file   ndk_bot.rb
# @author K.S.
#
# $Date: 2004/04/19 00:23:37 $
# $Id: ndk_bot.rb,v 1.1.1.1 2004/04/19 00:23:37 ko1 Exp $
#
# Create : K.S. 04/04/19 00:39:48
#

module Nadoka
  class NDK_Bot
    Cmd = Nadoka::Cmd
    Rpl = Nadoka::Rpl
    
    def initialize manager, config
      @manager = manager
      @config  = config
      @state   = manager.state
      
    end
    
    def method_missing(selector, *args)
      if /^on_/ =~ selector.to_s
        # do nothing...
      else
        raise NameError
      end
    end

    # usualy, you must not use this
    def send_privmsg ch, msg
      msg = Cmd.privmsg(ch, msg)
      @manager.send_to_server  msg
      @manager.send_to_clients msg
      nil
    end

    # mostly, you need this method.
    def send_notice ch, msg
      msg = Cmd.notice(ch, msg)
      @manager.send_to_server  msg
      @manager.send_to_clients msg
      nil
    end
    
    ###############################
    # override follows
    def on_privmsg user, ch, msg
      
    end
    
    def on_join user, ch
      
    end
    
    def on_part user, ch
      
    end
    
    def on_quit user, ch
      
    end

    # ...
    # def on_[IRC_CMD]
    #   
    # end
    #
  end
end


