#!/usr/bin/ruby
# @file   ndk_client.rb
# @author K.S.
#
# $Date: 2004/04/19 10:23:48 $
# $Id: ndk_client.rb,v 1.3 2004/04/19 10:23:48 ko1 Exp $
#
# Create : K.S. 04/04/17 16:50:10
#

require 'thread'

module Nadoka
  class NDK_Client
    def initialize config, sock, manager
      @config = config
      @sock   = sock
      @manager= manager
      @queue  = Queue.new
      @remote_host = @sock.peeraddr[2]
    end
    
    def start
      send_thread = Thread.new{
        begin
          while q = @queue.pop
            begin
              send_to_client q
            end
          end
        rescue Object
          @config.slog $!
          @config.slog $!.backtrace.join(' ')
          raise
        end
      }
      begin
        if login
          begin
            while msg = gets_from_client
              @manager.send_from_client msg, self
            end
          rescue NDK_QuitClient
            # finish
          rescue ::RICE::UnknownCommand, ::RICE::InvalidMessage
            retry
          end
        end
      rescue Object
        @config.slog $!
        @config.slog $!.backtrace.join(' ')
        raise
      ensure
        @config.slog "Client #{@realname}@#{@remote_host} disconnected."
        @sock.close
        send_thread.kill
      end
    end

    def gets_from_client
      str = @sock.gets
      if str
        @config.dlog "[<C] #{str}"
        ::RICE::Message::parse str
      end
    end
    
    def push msg
      @queue << msg
    end
    alias << push
    
    def login
      pass = nil
      nick = nil
      
      2.times{
        msg = gets_from_client
        @config.dlog "[<C] #{msg}"

        if msg.command == 'PASS'
          pass = msg.params[0]
          retry
        end
        
        if msg.command == 'USER'
          @username, @hostname, @servername, @realname = msg.params
        elsif msg.command == 'NICK'
          nick = msg.params[0]
        else
          raise "Illegal login sequence: #{msg}"
        end
      }
      if @config.client_server_pass && (@config.client_server_pass != pass)
        send_reply Rpl.err_passwdmismatch(nick, "Password Incorrect.")
        return false
      end
      
      send_reply Rpl.rpl_welcome( nick,
        'Welcome to the Internet Relay Network'+"#{nick}! #{@username}@#{@remote_host}")
      send_reply Rpl.rpl_yourhost(nick, "Your host is nadoka, running version #{NDK_Version}")
      send_reply Rpl.rpl_created( nick, 'This server was created ' + NDK_Created.to_s)
      send_reply Rpl.rpl_myinfo(  nick, "nadoka #{NDK_Version} aoOirw abeiIklmnoOpqrstv")
      send_reply Rpl.err_nomotd(  nick, 'MOTD File is missing' )
      
      send_command Cmd.nick(@manager.state.current_nick), nick
      nick = @manager.state.current_nick

      @manager.state.current_channels.each{|ch|
        send_command Cmd.join(ch)
        @manager.join_channel(ch)
      }
      
      @config.slog "Client #{@realname}@#{@remote_host} connected."
      true
    end

    # :who!~username@host CMD ..
    def send_command cmd, nick = @manager.state.current_nick
      msg = add_prefix(cmd, "#{nick}!~#{@username}@#{@remote_host}")
      send_msg msg
    end

    # :serverinfo REPL ...
    def send_reply repl
      msg = add_prefix(repl, "nadokatan")
      send_msg msg
    end

    def send_msg msg
      @config.dlog "[C>] #{msg}"
      @sock.puts msg.to_s
    end
    
    def send_to_client msg
      if /^\d+/ =~ msg.command
        send_reply msg
      else
        send_msg msg
      end
    end
    
    def add_prefix cmd, prefix
      cmd.prefix = prefix
      cmd
    end
  end
end

