#!/usr/bin/ruby
# @file   ndk_config.rb
# @author K.S.
#
# $Date: 2004/04/19 10:23:48 $
# $Id: ndk_config.rb,v 1.3 2004/04/19 10:23:48 ko1 Exp $
#
# Create : K.S. 04/04/17 16:50:33
#

module Nadoka
  class NDK_Logger
    def initialize level, config
      @level = level
      @config= config
      @dlog = @config.debug_log
    end
    
    def dlog msg
      if @config.loglevel >= 3
        logging(@dlog, msg)
      end
    end
    
    def slog msg
      logging(make_logfilename(@config.system_log), msg)
    end
    
    def clog ch, msg
      logfile = (@config.channel_info[ch] && @config.channel_info[ch][:log]) ||
                @config.default_log
      logfile = make_logfilename(logfile, ch)
      
      logging(logfile, msg)
    end

    def log msg
      if @config.loglevel >= 2
        logging(make_logfilename(@config.system_log), msg)
      end
    end

    def logging(io, msg)
      msg = "#{Time.now.strftime('%y/%m/%d-%H:%M:%S')} #{msg}"
      if io.respond_to? :puts
        io.puts msg
      else
        open(File.expand_path(@config.log_dir) + '/' + io, 'a'){|f|
          f.puts msg
        }
      end
    end

    def make_logfilename(tmpl, ch='')
      str = Time.now.strftime(tmpl)
      str.gsub!(/\$S/, @config.setting_name)
      str.gsub!(/\$C/, ch)
      str.tr!('\\/:*?<>|', '_')
      str
    end
  end

  class NDK_ConfigBase
    # system
    # 0: quiet, 1: ..., 2: ..., 3: debug
    Loglevel     = 3
    Setting_name = 'DefaultSetting',
    
    # client server
    Client_server_port = 16666
    Client_server_pass = 'passwd'
    
    # 
    Server_list        = [['127.0.0.1', 6667]]
    Server_passwd      = nil
    Default_channels   = []
    Login_channels     = []

    #
    User       = 'testbot'
    Nick       = 'test_bot'
    Hostname   = '0'
    Servername = '*'
    Realname   = 'test bot on nadoka'

    #
    Channel_info = {},
      
    # log
    Default_log= '$S-$C-%y%m.log'
    System_log = '$S-system_log'
    Debug_log  = $stdout
      
    # dirs
    Plugins_dir = './plugins'
    Log_dir     = './log'
    
    # bots
    Bots        = []
    BotConfig   = {}

    def self.inherited subklass
      ConfigClass << subklass
    end
  end
  ConfigClass = [NDK_ConfigBase]

  class NDK_Config
    NDK_ConfigBase.constants.each{|e|
      eval %Q{
        def #{e.downcase}
          @config['#{e.downcase}'.intern]
        end
      }
    }
    
    def initialize rcfile = nil
      load_config(rcfile || './nadokarc')
    end
    attr_reader :config
    
    def load_config(rcfile)
      load(rcfile) if rcfile

      @config = {}
      klass = ConfigClass.last
      klass.constants.each{|e|
        klass.const_get(e)
        @config[e.downcase.intern] = klass.const_get(e)
      }
      
      if svrs = klass.const_get(:Servers)
        svl = []
        svrs.each{|sv, ports|
          if ports.respond_to? :each
            ports.each{|port|
              svl << [sv, port]
            }
          else
            svl << [sv, ports]
          end
        }
        @config[:server_list] = svl
      end
      
      if chs = klass.const_get(:Channel_info)
        dchs = []
        lchs = []
        chs.each{|ch, setting|
          if setting[:timing] == :startup
            dchs << ch
          else
            lchs << ch
          end
        }
        @config[:default_channels] = dchs
        @config[:login_channels]   = lchs
      end
      @logger = NDK_Logger.new(0, self)
    end

    # debug message
    def dlog msg
      @logger.dlog msg
    end
    
    # system message
    def slog msg
      @logger.slog msg
    end

    # normal message
    def log msg
      @logger.log msg
    end
    
    # channel message
    def clog ch, msg
      @logger.clog ch, msg
    end
    
  end
end

if $0 == __FILE__
  require 'pp'
  pp Nadoka::NDK_Config.new('./prog')
end

