/**********************************************************************

  version.c -

  $Author: nobu $
  $Date: 2005/05/12 00:54:07 $
  created at: Thu Sep 30 20:08:01 JST 1993

  Copyright (C) 1993-2003 Yukihiro Matsumoto

**********************************************************************/

#include "ruby.h"
#include "version.h"
#include "yarv_version.h"
#include <stdio.h>

const char ruby_version[] = RUBY_VERSION;
const char ruby_release_date[] = RUBY_RELEASE_DATE;
const char ruby_platform[] = RUBY_PLATFORM;

void
Init_version()
{
#include "rev.inc"
    VALUE v = rb_obj_freeze(rb_str_new2(ruby_version));
    VALUE d = rb_obj_freeze(rb_str_new2(ruby_release_date));
    VALUE p = rb_obj_freeze(rb_str_new2(ruby_platform));
    VALUE vv = rb_obj_freeze(rb_str_new2(rev));
    VALUE vd = rb_obj_freeze(rb_str_new2(date));
    
    rb_define_global_const("RUBY_VERSION", v);
    rb_define_global_const("RUBY_RELEASE_DATE", d);
    rb_define_global_const("RUBY_PLATFORM", p);
    rb_define_global_const("RUBY_VM_REV", vv);
    rb_define_global_const("RUBY_VM_DATE", vd);
}

void
ruby_show_version()
{
#include "rev.inc"
  printf("ruby %s (Base: Ruby 1.9.0 %s) [%s]\n", RUBY_VERSION, RUBY_RELEASE_DATE, RUBY_PLATFORM);
  printf("%s Rev: %s (%s) [opts: %s]\n", yarv_version, rev, date, yarv_options);
  fflush(stdout);
}

void
ruby_show_copyright()
{
    printf("ruby - Copyright (C) 1993-%d Yukihiro Matsumoto\n", RUBY_RELEASE_YEAR);
    exit(0);
}
